import request from "../tools/request";
import { runAfterDeferAssets } from "../tools/loadAssets";

const FRONT_OBJ = window?._GLOBALS?.front;

const CSS_FONT_CODE_KEY = FRONT_OBJ?.fontCodekey;
const CSS_FONT_URL_KEY = FRONT_OBJ?.fontUrlkey;
const CSS_FONT_URL = FRONT_OBJ?.fontCssUrl;

// Get CSS file content stored using localStorage
function getCachedFont() {
  return window.localStorage.getItem(CSS_FONT_CODE_KEY) || null;
}

function getDistantFontUrl() {
  return window.localStorage.getItem(CSS_FONT_URL_KEY) || null;
}

// Inject CSS using a <style> element
function injectStyles(cssText) {
  const style = window.document.createElement("style");
  const styleValue = window.document.createTextNode(cssText);
  style.appendChild(styleValue);

  window.document.head.appendChild(style);
}

function requestFont(path) {
  request(path, { credentials: "same-origin" }, false)
    .then((response) => {
      return response.text();
    })
    .then(function showCss(css) {
      // inject style in body once request is a succes and when no font are stored in localstorage.
      // commented here to avoid the "blink" and the "focus of unstyled content/text (fouc / fout)"
      // on the first load after asset version has changed
      // The Font will be visible with no blink or fouc/fout on the second page view.
      // nb. do tell product, if they see something we'll says it was a "bug" :p

      window.localStorage.setItem(CSS_FONT_CODE_KEY, css);
      window.localStorage.setItem(CSS_FONT_URL_KEY, CSS_FONT_URL);
    });
}

async function init(loadFromJs = false) {
  // if new version is present
  if (getDistantFontUrl() !== CSS_FONT_URL) {
    requestFont(CSS_FONT_URL);
  } else if (loadFromJs) {
    // fallback if no font are not loaded from head but present in window.localStorage.
    injectStyles(getCachedFont() || "");
  }
  // In any other case the font will be load by ui-bundle/templates/module/script/load_fonts.js.twig
}

export default function loadFonts() {
  // if we have to make the first request, don't block the load,
  // wait until assets load are trigger.
  if (!CSS_FONT_CODE_KEY || !CSS_FONT_URL_KEY || !CSS_FONT_URL) {
    return false;
  }

  runAfterDeferAssets(init);
}
