import hasFullscreenAPI from "../../tools/testFullscreenApi";
import { addClass, removeClass } from "../../dom/classes";
import { CLASS_BODY_FULLSCREEN_ON } from "../../constant/dom";
import { BODY } from "../../constant/dom";

let IS_FULLSCREEN = false;

export function enterFullscreen(callback) {
    if (IS_FULLSCREEN || !!document.fullscreenElement) {
        return;
    }

    if (!hasFullscreenAPI()) {
        callback();
        addClass(BODY, CLASS_BODY_FULLSCREEN_ON);
        IS_FULLSCREEN = true;
        return;
    }

    document.documentElement.requestFullscreen().then(() => {
        callback();
        addClass(BODY, CLASS_BODY_FULLSCREEN_ON);
        IS_FULLSCREEN = true;
    });
}

export function exitFullscreen(callback) {
    if (!IS_FULLSCREEN) {
        return;
    }

    if (hasFullscreenAPI() && document.fullscreenElement) {
        document.exitFullscreen();
    }

    callback();
    removeClass(BODY, CLASS_BODY_FULLSCREEN_ON);
    IS_FULLSCREEN = false;
}

export function getFullscreenState() {
    return { open: IS_FULLSCREEN };
}
