# UI Bundle

A comprehensive front-end library for building modern web applications with reusable components, modules, and templates.

## Getting started

To use this bundle, you need to add some instructions in your composer.json:
```
{
    ...
    "require": {
        "webedia/ui-bundle": "^1.0"
    },
    ...
    "repositories": [
        {
            "type": "composer",
            "url": "https://gitlab.com/api/v4/group/56281921/-/packages/composer/"
        }
    ],
    ...
}
```

Don't forget to add aliases in webpack-config

```
.addAliases({
    '@Ui': path.resolve(__dirname, './vendor/webedia/ui-bundle/assets'),
})
```

## File Organization Logic

The UI Bundle follows a consistent naming convention where template modules, their corresponding CSS files, and JavaScript modules share the same base name for easy identification and maintenance:

### Naming Convention
- **Template**: `templates/module/component-name/component-name.html.twig`
- **CSS**: `assets/scss/module/component-name.scss`
- **JavaScript**: `assets/js/module/component-name/index.js`

### Examples
```
templates/module/header/header.html.twig
assets/scss/module/header.scss
assets/js/module/header/index.js
```

This organization ensures that:
- Each module has a clear, self-contained structure
- Related files are easily discoverable
- CSS and JavaScript dependencies are obvious
- Maintenance and updates are straightforward
- The relationship between template, styling, and interaction is clear

## Table of Contents

- [Overview](#overview)
- [Project Structure](#project-structure)
- [Frontend Assets Structure](#frontend-assets-structure)
- [Templates Structure](#templates-structure)

## Overview

The UI Bundle is a modular front-end library that provides a complete set of reusable UI components, modules, and templates for building web applications quickly and consistently. It features a comprehensive theming system, responsive design patterns, and a well-organized asset structure.

## Project Structure

```
ui-bundle/
├── assets/              # Frontend assets (SCSS, JS, fonts, icons)
├── templates/           # Twig templates
├── config/             # Configuration files
├── tests/              # Test files
├── package.json        # Node.js dependencies
└── composer.json       # PHP dependencies
```

## Frontend Assets Structure

### SCSS Organization
```
assets/scss/
├── app.scss                    # Main SCSS entry point
├── config/                     # Configuration and variables
│   ├── default_variables.scss  # Theme variables and settings
│   └── icon_config.scss        # Icon configuration
├── component/                  # Reusable UI components
│   ├── button.scss
│   ├── title.scss
│   ├── thumbnail.scss
│   ├── label.scss
│   ├── share.scss
│   ├── subtitle.scss
│   └── cta_subcategory.scss
├── module/                     # Complex UI modules
├── layout/                     # Layout and grid systems
└── helpers/                    # Mixins, extends, and utilities
```

### JavaScript Organization
```
assets/js/
├── module/                     # Feature-specific JS modules
│   ├── header/
│   ├── player/
│   ├── search/
│   ├── advertising/
│   ├── share/
│   ├── tracking/
│   ├── nativePlacements/
│   ├── overlay/
│   ├── roller/
│   └── darkMode/
├── services/                   # Shared services
├── tools/                      # Utility functions
├── dom/                        # DOM manipulation helpers
├── consent/                    # Consent management
└── constant/                   # Constants and configuration
```

### Asset Files
```
assets/
├── icon/                       # Icon assets
├── font/                       # Font files
├── scss/                       # Stylesheets
└── js/                         # JavaScript files
```

## Templates Structure

### Main Templates
```
templates/
├── base.html.twig              # Main layout template with:
│                               # - SEO meta tags
│                               # - Responsive viewport
│                               # - Asset loading
│                               # - Layout structure
│                               # - Consent management
│                               # - JavaScript integration
├── component/                  # Reusable UI components
│   ├── button.html.twig        # Flexible button system
│   ├── title.html.twig         # Configurable title system
│   ├── thumbnail.html.twig     # Image display component
│   ├── label.html.twig         # Tag/label system
│   ├── share.html.twig         # Social sharing
│   ├── subtitle.html.twig      # Subtitle component
│   ├── cta_subcategory.html.twig # Call-to-action
│   └── data_attributes.html.twig # Data attribute helper
├── module/                     # Complex UI modules
│   ├── header/                 # Site header and navigation
│   ├── footer/                 # Site footer
│   ├── search/                 # Search functionality
│   ├── player/                 # Media player integration
│   ├── ads/                    # Advertising system
│   ├── consent/                # GDPR/consent management
│   ├── breadcrumb/             # Navigation breadcrumbs
│   ├── pagination/             # Content pagination
│   ├── roller/                 # Content carousel/slider
│   ├── nav/                    # Navigation components
│   ├── dropdown/               # Dropdown menus
│   ├── script/                 # Script templates
│   ├── nonli/                  # Non-list components
│   ├── native_placements/      # Native advertising
│   ├── news_cards/             # News card layouts
│   ├── directory/              # Directory listings
│   ├── anchor/                 # Anchor components
│   ├── article/                # Article layouts
│   ├── author/                 # Author components
│   ├── c2c/                    # Call-to-action modules
│   └── darkMode/               # Dark mode components
└── section/                    # Page sections
    └── dynamic_content/        # Dynamic content sections
```

### Component Templates

#### Button Component (`templates/component/button.html.twig`)
- **Purpose**: Flexible button system with multiple variants
- **Features**:
  - Multiple sizes (sm, md, lg)
  - Color variants and backgrounds
  - Icon support
  - Link and button types
  - Position control (start, center, end)
  - Data attributes support

#### Title Component (`templates/component/title.html.twig`)
- **Purpose**: Configurable title system for pages and sections
- **Features**:
  - Page and section title types
  - Logo integration
  - Link wrapping
  - Subtitle support
  - Uppercase option
  - Roller integration

#### Thumbnail Component (`templates/component/thumbnail.html.twig`)
- **Purpose**: Image display with various configurations
- **Features**:
  - Responsive image handling
  - Lazy loading
  - Multiple aspect ratios
  - Overlay support
  - Link wrapping

### Module Templates

#### Header Module (`templates/module/header/`)
- **Purpose**: Site header and navigation
- **Features**:
  - Logo display
  - Main navigation menu
  - Search integration
  - User account features
  - Responsive mobile menu

#### Footer Module (`templates/module/footer/`)
- **Purpose**: Site footer with links and information
- **Features**:
  - Footer navigation
  - Social media links
  - Legal information
  - Newsletter signup

#### Search Module (`templates/module/search/`)
- **Purpose**: Search functionality
- **Features**:
  - Search form
  - Autocomplete
  - Search results display
  - Filter options

#### Player Module (`templates/module/player/`)
- **Purpose**: Media player integration
- **Features**:
  - Video player
  - Audio player
  - Playlist support
  - Custom controls

#### Ads Module (`templates/module/ads/`)
- **Purpose**: Advertising system integration
- **Features**:
  - Banner ads
  - Rectangle ads
  - Sticky ads
  - Ad tracking
  - Responsive ad units

#### Consent Module (`templates/module/consent/`)
- **Purpose**: GDPR and consent management
- **Features**:
  - Cookie consent banner
  - Privacy settings
  - Consent tracking
  - Didomi integration

### Base Template Features

The `base.html.twig` template provides:

#### SEO Integration
- Dynamic meta tags
- Open Graph support
- Twitter Card support
- Structured data
- Breadcrumb integration

#### Asset Management
- CSS preloading
- JavaScript loading
- Font loading optimization
- Icon system integration

#### Layout Structure
- Responsive grid system
- Two-column layout support
- Header and footer areas
- Main content area
- Sidebar support

#### Performance Features
- Resource preloading
- Lazy loading support
- Optimized asset delivery
- Cache-friendly structure

#### Accessibility
- ARIA labels and roles
- Semantic HTML structure
- Keyboard navigation support
- Screen reader compatibility
