import { removeClass, addClass } from "../../dom/classes";
import { onYScroll } from "../../tools/yScroll";
import { BODY } from "../../constant/dom";

const MINIFY_HEADER_CLASS = 'header-min';

let windowTop = window.scrollY || document.documentElement.scrollTop;
let headerMinified = false;

function handleHeaderMinOnScroll(yScroll) {
  if (window.MqState.getState() < 3) {
    return false;
  }

  // Edge behavior.
  // Don't start this minify header under 100px of the top.
  // Don't remove minify header on the bottom of the scroll.
  // Avoid weird FX on tablette bouncing scroll.
  const viewportBottom =
    window.innerHeight || document.documentElement.clientHeight;

  if (yScroll < 100) {
    removeClass(BODY, MINIFY_HEADER_CLASS);
    headerMinified = false;
    windowTop = yScroll;
    return false;
  }

  if (
    yScroll >= document.body.scrollHeight - viewportBottom - 150 &&
    headerMinified === true
  ) {
    windowTop = yScroll;
    return false;
  }

  // Classic behavior
  if (windowTop < yScroll && !headerMinified) {
    addClass(BODY, MINIFY_HEADER_CLASS);
    headerMinified = true;
  }

  if (windowTop > yScroll && headerMinified) {
    removeClass(BODY, MINIFY_HEADER_CLASS);
    headerMinified = false;
  }

  windowTop = yScroll;
}

export default function init() {
  onYScroll((yScroll) => {
    handleHeaderMinOnScroll(yScroll);
  });
}
