/* IMPORTANT : USE Jan WRAPPER */

import loadScript from 'load-script';
import { hasAdblock } from "../../tools/ads";
import { on } from "../../dom/events";
import handInterSectionObserver from "../../tools/intersectionObserverItems";

const jan_src = window._GLOBALS?.jan_config?.src;
const GA_OBJECT = window._GLOBALS?.ga;
const JAD_OBJECT = window._GLOBALS?.jad_config;

const elementSet = new Set();

export default async function initJan() {
  if (!jan_src || !GA_OBJECT) {
    return;
  }

  //console.debug("Jan setConfig : ", getBaseTrackingObj());

  jancmd("setConfig", {
    metadata: {
      ...getBaseTrackingObj()
    },
  });

  loadScript(jan_src, {}, async () => {
    jancmd("sendEvent", "pageview");
    handleDomHitElements();
  });
}

function getBaseTrackingObj() {
  return {
    ...setAdblockTrackingObj(),
    ad_unit: JAD_OBJECT?.page,
    referrer: window.document.referrer,
    ...GA_OBJECT
  }
}

function setAdblockTrackingObj() {
  return {
    adblock_hit: hasAdblock() ? 'adblock' : 'no-adblock',
    adblock_session: hasAdblock() ? 'adblock' : 'no-adblock',
    adblock_user: hasAdblock() ? 'adblock' : 'no-adblock'
  }
}

export function hit(event, obj) {
  //console.debug("Jan sendEvent : ", event, obj);
  jancmd("sendEvent", event, obj);
}

export function handleDomHitElements() {
  const elements = document.querySelectorAll('*[data-jan]');

  // We do that to avoid sending double hit in AJAX mode when DOM is retrived for the seconde time or more
  elements.forEach(item => {
    if (elementSet.has(item)) {
      elementSet.delete(item);
    } else {
      elementSet.add(item);
    }
  });

  elementSet.forEach(item => {
    const tackingObj = JSON.parse(item.dataset.jan);

    /*
    EVENT ACTION (eventAction in JAN data-set can be either a single string or an array of string values):
      - load : send a hit when the element is present in the document
      - view : send a hit when the element is visible by the user (in the viewport)
      - click : send a hit when the element is clicked by the user
    */

    if (tackingObj) {
      const hitObj = {...tackingObj};
      const eventAction = tackingObj.eventAction;
      const eventName = tackingObj.eventName;

      delete hitObj.eventAction;
      delete hitObj.eventName;

      // Here, impression is used as "element is present in the page on load".
      if (eventAction.includes('load') || eventAction === "load") {
        hit(`${eventName}_load`, hitObj);
      }

      // Here it's used as a "impression on view" meaning that the element is in the viewport.
      // We use intersectionObserver to trigger the hit.
      // WARNING => EventAction === "impression" will be deprecated soon and will be removed.
      if (eventAction.includes('view') || eventAction === "view" || eventAction === "impression") {
        handInterSectionObserver([{
          element: item,
          callback: (entry, observer) => {
            if (entry.isIntersecting) {
              hit(`${eventName}_view`, hitObj);
              hit(`${eventName}_impression`, hitObj);
              observer.unobserve(item);
            }
          },
          options: {
            threshold: 0.5
          }
        }])
      }

      if (eventAction.includes('click') || eventAction === "click") {
        on(item, 'click', () => {
          hit(`${eventName}_click`, hitObj);
        });
      }
    }
  });
}
