import { getConsentForAnalitycs } from './didomi';
import noop from '../tools/noop';

const PIXEL_URL = 'https://bpt.webedia-group.com/pixel.png?/';
const SITE_ROUTE =  window?._GLOBALS?.routes?.current;

export async function getConsentState(continueWoConsent = false) {
  return new Promise(resolve => {
    if (!window.__tcfapi) {
      resolve(false);
      return;
    }

    const getConsent = (tcData) => {
      try {
        if (
          tcData.eventStatus === 'useractioncomplete' ||
          tcData.eventStatus === 'tcloaded'
        ) {
          window.__tcfapi('removeEventListener', 2, getConsent);
          resolve(true);
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error in getting consent : ${e}`);

        if (continueWoConsent) {
          resolve(false);
        }
      }
    };

    window.__tcfapi('addEventListener', 2, getConsent);
  });
}

export function trackConsent(hitCb = false, hitObj = false) {
  let tcfok = false;

  if (window.__tcfapi) {
    window.__tcfapi('addEventListener', 2, function (tcData) {
      try {
        switch (tcData.eventStatus) {
          case 'useractioncomplete':
            triggerConsentTracking(tcData.eventStatus, hitCb, hitObj);
            window.__tcfapi('removeEventListener', 2, noop, tcData.listenerId);
            break;
          case 'cmpuishown':
            triggerConsentTracking(tcData.eventStatus, false, false);
            break;
          case 'tcloaded':
            triggerConsentTracking(tcData.eventStatus, false, false);
            window.__tcfapi('removeEventListener', 2, noop, tcData.listenerId);
            break;
          default:
            triggerConsentTracking(tcData.eventStatus, hitCb, hitObj);
        }
      } catch (error) {
        triggerConsentTracking('tcferror', hitCb, hitObj);
      }
      tcfok = true;
    });
  }

  setTimeout(function () {
    if (!tcfok) {
      triggerConsentTracking('tcfnotloaded', false, false);
    }
  }, 2000);
}

async function triggerConsentTracking(tcfStatus, hitCb, hitObj) {
  let done = false;

  const trackingTimeout = setTimeout(() => {
    sendBecon('timeout', 'false', tcfStatus);
  }, 1000);

  function sendBecon(method, consent, tcfStatus) {
    if (!done) {
      if (hitCb) {
        hitCb(hitObj);
      }

      sendPixel(method, consent, tcfStatus);

      if (trackingTimeout) {
        clearTimeout(trackingTimeout);
      }

      done = true;
    }
  }

  const consent = await getConsentForAnalitycs(false);
  const consentToString = consent == undefined ? 'undefined' : consent;

  sendBecon('didomiOnReady', consentToString, tcfStatus);
}

function sendPixel(
  method,
  consent,
  status
) {
    if (!SITE_ROUTE) {
        return false;
    }
    const pixelParam = `domain=${window.location.host}&referrer=${document.referrer}&site_route=${SITE_ROUTE}&event=tcfapi&method=${method}&consent=${consent}&tcfStatus=${status}`;

    //console.debug('sendPixel : ', method, consent, status);

    try {
        fetch(PIXEL_URL + pixelParam);
    } catch (e) {
        // eslint-disable-next-line no-console
        console.warn(`Error sending pixel : ${e}`);
    }
}
