# ui-bundle

@UiBundle is a front library for Symfony.

## Getting started

To use this bundle, you need to add some instructions in your composer.json:
```
{
    ...
    "config": {
        "preferred-install": {
            "webedia/ui-bundle": "source"
        }
    },
    ...
    "repositories": [
        {
            "name": "webedia/front-bundle",
            "type": "git",
            "url": "https://gitlab.com/johann.kurek/frontbundletest.git"
        }
    ],
    ...
}
```

Then, you need to create two aliases for this bundle in your webpack.config.js:
```
.addAliases({
    '@Ui': path.resolve(__dirname, './vendor/webedia/ui-bundle/assets'),
})
```

Now you can download the bundle from git to your project:
```
composer require webedia/ui-bundle dev-main
```

## Integration
To use a component or a module from the bundle in twig:
```
{% include "@UiBundle/module/ads/rectangle.html.twig" with {
    position: "atf",
    is_sticky: true,
    ad_id: "rectangle_atf"
} only %}
```

To use the associated css, you need to import the source in your scss:
```
@import '@Ui/scss/module/ads';
```

To use the associated js, you need to import the source in your js app:
```
import '@Ui/js/module/roller';
roller();
```