import { on } from "../dom/events";

export default function setupTouchEvents(container, cbObj = {
  onSwipeLeft: null,
  onSwipeRight: null,
  onSwipeUp: null,
  onSwipeDown: null,
}) {
    let startX = 0;
    let startY = 0;
    let isDraggingHorizontally = false;
    let isDraggingVertically = false;

    on(container, "touchstart", (e) => {
        startX = e.touches[0].clientX;
        startY = e.touches[0].clientY;
        isDraggingHorizontally = false;
        isDraggingVertically = false;
    });

    on(container, "touchmove", (e) => {
        if (!startX || !startY) return;

        const currentX = e.touches[0].clientX;
        const currentY = e.touches[0].clientY;
        const diffX = startX - currentX;
        const diffY = startY - currentY;

        // Only consider it a drag if horizontal movement is greater than vertical
        if (Math.abs(diffX) > Math.abs(diffY) && Math.abs(diffX) > 10) {
            isDraggingHorizontally = true;
            e.preventDefault();
        } else if (Math.abs(diffY) > Math.abs(diffX) && Math.abs(diffY) > 10) {
            isDraggingVertically = true;
            e.preventDefault();
        }
    });

    on(container, "touchend", (e) => {
        if (!isDraggingHorizontally && !isDraggingVertically) {
          return;
        }

        const threshold = 50;

        if (isDraggingHorizontally && startX) {
          const endX = e.changedTouches[0].clientX;
          const diffX = startX - endX;

          if (Math.abs(diffX) > threshold) {
            if (diffX > 0) {
              cbObj.onSwipeLeft?.();
            } else {
              cbObj.onSwipeRight?.();
            }
          }
        }

        if (isDraggingVertically && startY) {
          const endY = e.changedTouches[0].clientY;
          const diffY = startY - endY;

          if (Math.abs(diffY) > threshold) {
            if (diffY > 0) {
              cbObj.onSwipeUp?.();
            } else {
              cbObj.onSwipeDown?.();
            }
          }
        }

        startX = 0;
        startY = 0;
        isDraggingHorizontally = false;
        isDraggingVertically = false;
    });
}
