/* IMPORTANT : USE Jan WRAPPER */

import loadScript from 'load-script';
import { hasAdblock } from "../../tools/ads";
import { on } from "../../dom/events";

const jan_src = window._GLOBALS?.jan_config?.src;
const GA_OBJECT = window._GLOBALS?.ga;
const JAD_OBJECT = window._GLOBALS?.jad_config;

export default function initJan() {
  if (!jan_src || !GA_OBJECT) {
    return;
  }

  //console.debug("Jan setConfig : ", getBaseTrackingObj());

  jancmd("setConfig", {
    metadata: {
      ...getBaseTrackingObj()
    },
  });

  loadScript(jan_src, {}, () => {
    jancmd("sendEvent", "pageview");
    handleDomHitElements();
  });
}

function getBaseTrackingObj() {
  return {
    ...setAdblockTrackingObj(),
    ...GA_OBJECT,
    ad_unit: JAD_OBJECT?.page,
    referrer: window.document.referrer
  }
}

function setAdblockTrackingObj() {
  return {
    adblock_hit: hasAdblock() ? 'adblock' : 'no-adblock',
    adblock_session: hasAdblock() ? 'adblock' : 'no-adblock',
    adblock_user: hasAdblock() ? 'adblock' : 'no-adblock'
  }
}

export function hit(event, obj) {
  //console.debug("Jan sendEvent : ", event, obj);
  jancmd("sendEvent", event, obj);
}

function handleDomHitElements() {
  const elements = document.querySelectorAll('*[data-jan]');
  const impressionSet = new Set();

  elements.forEach(item => {
    const tackingObj = JSON.parse(item.dataset.jan);

    if (tackingObj) {
      const hitObj = {...tackingObj};
      const eventAction = tackingObj.eventAction;
      const eventName = tackingObj.eventName;

      delete hitObj.eventAction;
      delete hitObj.eventName;

      if ((eventAction === "impression" || eventAction === "both") && !impressionSet.has(eventName)) {
        impressionSet.add(eventName);
        hit(`${eventName}_impression`, hitObj);
      }

      on(item, 'click', () => {
        hit(`${eventName}_click`, hitObj);
      });
    }
  });
}
