<?php

namespace Webedia\UiBundle\Tests;

use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;
use Webedia\UiBundle\Service\MenuBuilder;

class MenuTest extends KernelTestCase {

    public function testMainMenu() {
        self::bootKernel();
        $container = static::getContainer();
    
        $menuBuilder = $container->get(MenuBuilder::class);

        $mainMenu = $menuBuilder->createMainMenu();

        $names = array_values(array_map(function($child) {
            return $child->getName();
        }, $mainMenu->getChildren()));

        // test menu names
        $this->assertEquals([
            'Voitures vertes',
            'Scooter et moto',
            'Applis / services',
            'Bonus / malus / fiscalité des entreprises',
        ], $names);
    }

    public function testLinkBar() {
        self::bootKernel();
        $container = static::getContainer();
    
        $menuBuilder = $container->get(MenuBuilder::class);

        $mainMenu = $menuBuilder->createLinkBar();

        $names = array_values(array_map(function($child) {
            return $child->getName();
        }, $mainMenu->getChildren()));

        // test menu names
        $this->assertEquals([
            'Affaire conclue',
            'Mask Singer',
            'Mariés Au Premier Regard'
        ], $names);
    }
}