import testIosDevice from "./testIosDevice";

export default function hasFullscreenAPI() {
    // Device and browser detection
    const isIOS = testIosDevice();

    // Test fullscreen API methods
    const fullscreenAPI = {
        requestFullscreen: !!document.documentElement.requestFullscreen,
        exitFullscreen: !!document.exitFullscreen,
        fullscreenElement: "fullscreenElement" in document,
        fullscreenEnabled: "fullscreenEnabled" in document,
        fullscreenchange: "onfullscreenchange" in document,
        fullscreenerror: "onfullscreenerror" in document,
    };

    // Test vendor prefixes
    const vendorPrefixes = {
        webkitRequestFullscreen:
            !!document.documentElement.webkitRequestFullscreen,
        mozRequestFullScreen: !!document.documentElement.mozRequestFullScreen,
        msRequestFullscreen: !!document.documentElement.msRequestFullscreen,
    };

    // Overall compatibility assessment
    const hasFullscreenSupport =
        fullscreenAPI.requestFullscreen ||
        vendorPrefixes.webkitRequestFullscreen ||
        vendorPrefixes.mozRequestFullScreen ||
        vendorPrefixes.msRequestFullscreen;

    return !isIOS && hasFullscreenSupport;
}
