import { addClass } from "../../dom/classes";

const countdownBanner = document.querySelector('.js-banner-countdown');
const countdownElement = countdownBanner.querySelector('.countdown');

function getDuration(ms) {
  const days = Math.floor(ms / (24 * 60 * 60 * 1000));
  const hours = Math.floor((ms % (24 * 60 * 60 * 1000)) / (60 * 60 * 1000));
  const minutes = Math.floor((ms % (60 * 60 * 1000)) / (60 * 1000));

  return {
    'days': days,
    'hours': hours,
    'minutes': minutes
  };
};

function updateCountdown(timesRemaning) {
  const days = countdownElement.querySelector('.countdown-days');
  const hours = countdownElement.querySelector('.countdown-hours');
  const minutes = countdownElement.querySelector('.countdown-minutes');

  if (!timesRemaning) {
    addClass(countdownElement, 'hide');

    const title = countdownBanner.querySelector('.title');
    const description = countdownBanner.querySelector('.description');
    const cta = countdownBanner.querySelector('.cta');

    title.textContent = countdownBanner.dataset.afterTitle;
    description.textContent = countdownBanner.dataset.afterDescription;
    cta.textContent = countdownBanner.dataset.afterCtaText;
    cta.href = countdownBanner.dataset.afterCtaUrl;

    return false;
  }

  if (days.textContent !== timesRemaning.days) {
    days.textContent = timesRemaning.days;
  }

  if (hours.textContent !== timesRemaning.hours) {
    hours.textContent = timesRemaning.hours;
  }

  if (minutes.textContent !== timesRemaning.minutes) {
    minutes.textContent = timesRemaning.minutes;
  }
}

function setCountdownTime(targetTime) {
  const intervalCountdown = setInterval(() => {
    const timeToGo = targetTime - Date.now();

    if (timeToGo <= 60000) {
      clearInterval(intervalCountdown);
      updateCountdown(null);
      return false;
    }

    const timesRemaning = getDuration(timeToGo);

    updateCountdown(timesRemaning);

  }, 10000);
};

export default function initBannerCountdown() {
  if (!countdownBanner || !countdownElement) {
    return false;
  }

  const targetTime = Date.parse(countdownElement.dataset.date);

  if (!targetTime) {
    return false;
  }

  setCountdownTime(targetTime);
}

