import loadScript from "load-script";

let AUDION_PLAYER_READER = false;

export default async function audionReader() {
  const audioPlayer = document.getElementById("audion_player_placeholder");

  if (!audioPlayer || AUDION_PLAYER_READER) {
    return false;
  }

  // Récupération de l'URL depuis la configuration du projet
  const AUDION_URL = audioPlayer.dataset.src || null;

  if (!AUDION_URL) {
    return false;
  }

  loadScript(AUDION_URL, () => {
    AUDION_PLAYER_READER = true;
  });
}
