<?php

namespace Webedia\UiBundle\Tests\TestApp\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Webedia\UiBundle\Contracts\Implementation\LinkBarItem;

class TestController extends AbstractController
{
    #[Route('/', name: 'home')]
    public function home(): Response
    {
        return $this->render('home.html.twig', []);
    }

    #[Route('/legacy_menu', name: 'home_with_legacy_menu')]
    public function home_with_legacy_menu(): Response
    {
        $linkBar = [
            'affaire-conclue' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 2,
                    'slug' => 'affaire-conclue'
                ],
                'label' => 'Affaire conclue'
            ],
            'mask-singer' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 3,
                    'slug' => 'mask-singer'
                ],
                'label' => 'Mask Singer'
            ],
            'maries-au-premier-regard' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 4,
                    'slug' => 'maries-au-premier-regard'
                ],
                'label' => 'Mariés Au Premier Regard'
            ]
        ];

        $mainMenu = [
            'voitures-vertes' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 1,
                    'slug' => 'voitures-vertes'
                ],
                'label' => 'Voitures vertes'
            ],
            'scooter-et-moto' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 2,
                    'slug' => 'scooter-et-moto'
                ],
                'label' => 'Scooter et moto'
            ],
            'appli-services' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 3,
                    'slug' => 'appli-services'
                ],
                'label' => 'Applis / services'
            ],
            'bonus-malus-fiscalite-des-entreprises' => [
                'route_name' => 'category_show',
                'route_params' => [
                    'id' => 4,
                    'slug' => 'bonus-malus-fiscalite-des-entreprises'
                ],
                'label' => 'Bonus / malus / fiscalité des entreprises',
                'sous-menu' => [
                    [
                        'route' => 'category_show',
                        'route_params' => [
                            'id' => 1,
                            'slug' => 'sous-menu'
                        ],
                        'label' => 'Sous menu'
                    ]
                ]
            ]
        ];

        return $this->render('home_with_legacy_menu.html.twig', [
            'link_bar' => $linkBar,
            'main_menu' => $mainMenu
        ]);
    }

    #[Route('/category/{slug}_c{id}', name: 'category_show', requirements: ['id' => '\d+'])]
    public function showCategory(): Response
    {
        return $this->render('category_show.html.twig', []);
    }

    #[Route('/contracts_demo', name: 'contracts_demo')]
    public function contractsDemo(): Response
    {
        // New typed approach using contracts
        $linkBarItems = [
            new LinkBarItem(
                routeName: 'category_show',
                routeParams: ['id' => 1, 'slug' => 'demo-category'],
                label: 'Demo Category',
                tracking: 'demo_tracking'
            ),
        ];

        return $this->render('home.html.twig', [
            'link_bar' => $linkBarItems,
        ]);
    }
}
