<?php

namespace Webedia\UiBundle\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class HomeTest extends WebTestCase {

    public function testMenuAndLinkBarDisplay(): void {
        // test main menu display on home page
        $client = static::createClient();

        $crawler = $client->request('GET', '/');

        $this->assertResponseIsSuccessful();

        // get array of main menu links
        $mainMenuTexts = $crawler->filter('a.header-main-nav-link')->extract(['_text']);

        // check if the link labels are correct
        $this->assertEquals([
            'Voitures vertes',
            'Scooter et moto',
            'Applis / services',
            'Bonus / malus / fiscalité des entreprises',
        ], $mainMenuTexts);

        // get array of link bar links
        $linkBarTexts = $crawler->filter('a.link-bar-seo')->extract(['_text']);

        $this->assertEquals([
            'Affaire conclue',
            'Mask Singer',
            'Mariés Au Premier Regard'
        ], $linkBarTexts);
    }

    public function testMenuAndLinkBarDisplayWithLegacyMenu(): void {
        // test main menu display on home page
        $client = static::createClient();

        $crawler = $client->request('GET', '/legacy_menu');

        $this->assertResponseIsSuccessful();

        // get array of main menu links
        $mainMenuTexts = $crawler->filter('a.header-main-nav-link')->extract(['_text']);

        // check if the link labels are correct
        $this->assertEquals([
            'Voitures vertes',
            'Scooter et moto',
            'Applis / services',
            'Bonus / malus / fiscalité des entreprises',
        ], $mainMenuTexts);

        // get array of link bar links
        $linkBarTexts = $crawler->filter('a.link-bar-seo')->extract(['_text']);

        $this->assertEquals([
            'Affaire conclue',
            'Mask Singer',
            'Mariés Au Premier Regard'
        ], $linkBarTexts);
    }
}