<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts;

use ArrayAccess;

/**
 * Base interface for template data objects that supports both object and array access patterns.
 * This ensures backward compatibility with existing array-based template data while enabling
 * type-safe interfaces for new implementations.
 */
interface TemplateDataInterface
{
    /**
     * Validate that the object contains all required data.
     * Returns true if valid, false otherwise.
     */
    public function validate(): bool;
}
