<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Section;

use Webedia\UiBundle\Contracts\Section\LayoutRollerConfigInterface;

class LayoutRollerConfig implements LayoutRollerConfigInterface
{
    /** @param mixed[] $entities */
    public function __construct(
        private array $entities = [],
        private ?string $blockPath = null
    ) {}

    /** @return mixed[] */
    public function getEntities(): array
    {
        return $this->entities;
    }

    public function getBlockPath(): ?string
    {
        return $this->blockPath;
    }

    public function validate(): bool
    {
        return true; // No required fields for this layout
    }
}