<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Section;

use Webedia\UiBundle\Contracts\Section\LayoutGridSimpleConfigInterface;

class LayoutGridSimpleConfig implements LayoutGridSimpleConfigInterface
{
    /** @param mixed[] $entities */
    public function __construct(
        private string $gapSize = '20',
        private string $gdLNumber = '4',
        private array $entities = []
    ) {}

    public function getGapSize(): string
    {
        return $this->gapSize;
    }

    public function getGdLNumber(): string
    {
        return $this->gdLNumber;
    }

    /** @return mixed[] */
    public function getEntities(): array
    {
        return $this->entities;
    }

    public function validate(): bool
    {
        return true; // No required fields for this layout
    }
}