<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Section;

use Webedia\UiBundle\Contracts\Section\Layout2ColsAdsConfigInterface;

class Layout2ColsAdsConfig implements Layout2ColsAdsConfigInterface
{
    /** @param mixed[] $entities */
    public function __construct(
        private array $leftColClasses = [],
        private array $rightColClasses = [],
        private string $gapSize = '20',
        private array $entities = []
    ) {}

    public function getLeftColClasses(): array
    {
        return $this->leftColClasses;
    }

    public function getRightColClasses(): array
    {
        return $this->rightColClasses;
    }

    public function getGapSize(): string
    {
        return $this->gapSize;
    }

    /** @return mixed[] */
    public function getEntities(): array
    {
        return $this->entities;
    }

    public function validate(): bool
    {
        return true; // No required fields for this layout
    }
}