<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Section;

use Webedia\UiBundle\Contracts\Section\BaseLayoutConfigInterface;

class BaseLayoutConfig implements BaseLayoutConfigInterface
{
    public function __construct(
        private bool $bigSection = false,
        private array $sectionClasses = [],
        private bool $hasCta = false,
        private ?string $ctaHref = null,
        private ?string $ctaText = null,
        private ?string $ctaType = null,
        private ?string $ctaSize = null
    ) {}

    public function isBigSection(): bool
    {
        return $this->bigSection;
    }

    public function getSectionClasses(): array
    {
        return $this->sectionClasses;
    }

    public function hasCta(): bool
    {
        return $this->hasCta;
    }

    public function getCtaHref(): ?string
    {
        return $this->ctaHref;
    }

    public function getCtaText(): ?string
    {
        return $this->ctaText;
    }

    public function getCtaType(): ?string
    {
        return $this->ctaType;
    }

    public function getCtaSize(): ?string
    {
        return $this->ctaSize;
    }

    public function validate(): bool
    {
        if ($this->hasCta) {
            return !empty($this->ctaHref) && !empty($this->ctaText);
        }
        return true;
    }
}