<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\SearchConfigInterface;

class SearchConfig implements SearchConfigInterface
{
    public function __construct(
        private ?string $placeHolder = null,
        private ?string $searchPath = null,
        private string $searchMethod = 'post',
        private string $searchInputName = 'q',
        private string $searchInputId = 'search_bar'
    ) {}

    public function getPlaceHolder(): ?string
    {
        return $this->placeHolder;
    }

    public function getSearchPath(): ?string
    {
        return $this->searchPath;
    }

    public function getSearchMethod(): string
    {
        return $this->searchMethod;
    }

    public function getSearchInputName(): string
    {
        return $this->searchInputName;
    }

    public function getSearchInputId(): string
    {
        return $this->searchInputId;
    }

    public function validate(): bool
    {
        return true; // Search has no required fields
    }
}