<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\RollerConfigInterface;

class RollerConfig implements RollerConfigInterface
{
    public function __construct(
        private ?string $id = null,
        private array $classes = [],
        private int $offset = 15,
        private array $dataAttr = [],
        private bool $noNav = false,
        private string $iconLeft = 'chevron_left',
        private string $iconRight = 'chevron_right',
        private bool $websiteDirectionRtl = false
    ) {}

    public function getId(): ?string
    {
        return $this->id;
    }

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function getOffset(): int
    {
        return $this->offset;
    }

    public function getDataAttr(): array
    {
        return $this->dataAttr;
    }

    public function isNoNav(): bool
    {
        return $this->noNav;
    }

    public function getIconLeft(): string
    {
        return $this->iconLeft;
    }

    public function getIconRight(): string
    {
        return $this->iconRight;
    }

    public function isWebsiteDirectionRtl(): bool
    {
        return $this->websiteDirectionRtl;
    }

    public function validate(): bool
    {
        return true; // Roller has no required fields
    }
}