<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\RectangleAdConfigInterface;

class RectangleAdConfig implements RectangleAdConfigInterface
{
    public function __construct(
        private string $position,
        private bool $sticky = false,
        private string $adId,
        private array $classes = []
    ) {}

    public function getPosition(): string
    {
        return $this->position;
    }

    public function isSticky(): bool
    {
        return $this->sticky;
    }

    public function getAdId(): string
    {
        return $this->adId;
    }

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function validate(): bool
    {
        return !empty($this->position) && !empty($this->adId);
    }
}