<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\PlayerConfigInterface;

class PlayerConfig implements PlayerConfigInterface
{
    public function __construct(
        private ?string $iframeSrc = null,
        private ?string $iframeTitle = null,
        private ?string $videoId = null,
        private ?string $playlistId = null,
        private ?string $mediaId = null,
        private bool $mainMedia = false,
        private array $playerClasses = [],
        private ?string $playerThumbnail = null,
        private bool $playerInternal = false
    ) {}

    public function getIframeSrc(): ?string
    {
        return $this->iframeSrc;
    }

    public function getIframeTitle(): ?string
    {
        return $this->iframeTitle;
    }

    public function getVideoId(): ?string
    {
        return $this->videoId;
    }

    public function getPlaylistId(): ?string
    {
        return $this->playlistId;
    }

    public function getMediaId(): ?string
    {
        return $this->mediaId;
    }

    public function isMainMedia(): bool
    {
        return $this->mainMedia;
    }

    public function getPlayerClasses(): array
    {
        return $this->playerClasses;
    }

    public function getPlayerThumbnail(): ?string
    {
        return $this->playerThumbnail;
    }

    public function isPlayerInternal(): bool
    {
        return $this->playerInternal;
    }

    public function validate(): bool
    {
        return $this->iframeSrc !== null ||
               $this->videoId !== null ||
               $this->playlistId !== null ||
               $this->mediaId !== null;
    }
}