<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\PaginationConfigInterface;

class PaginationConfig implements PaginationConfigInterface
{
    public function __construct(
        private mixed $pagination,
        private mixed $manualRoute = null
    ) {}

    public function getPagination(): mixed
    {
        return $this->pagination;
    }

    public function getManualRoute(): ?callable
    {
        return $this->manualRoute;
    }

    public function validate(): bool
    {
        return $this->pagination !== null;
    }
}