<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\NewsCardConfigInterface;

class NewsCardConfig implements NewsCardConfigInterface
{
    public function __construct(
        private string $imgRatio = '16:9',
        private array $cardClasses = [],
        private array $figureClasses = [],
        private ?string $cardType = null,
        private ?string $cardSize = null,
        private ?string $cardColor = null,
        private ?string $cardBorder = null,
        private ?string $cardShadow = null
    ) {}

    public function getImgRatio(): string
    {
        return $this->imgRatio;
    }

    public function getCardClasses(): array
    {
        return $this->cardClasses;
    }

    public function getFigureClasses(): array
    {
        return $this->figureClasses;
    }

    public function getCardType(): ?string
    {
        return $this->cardType;
    }

    public function getCardSize(): ?string
    {
        return $this->cardSize;
    }

    public function getCardColor(): ?string
    {
        return $this->cardColor;
    }

    public function getCardBorder(): ?string
    {
        return $this->cardBorder;
    }

    public function getCardShadow(): ?string
    {
        return $this->cardShadow;
    }

    public function validate(): bool
    {
        return true; // News card has no required fields
    }
}