<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

/**
 * Interface for link bar navigation items.
 *
 * This interface defines the structure expected by link_bar_raw_menu.html.twig
 * and provides backward compatibility with existing array-based implementations.
 */
interface LinkBarItemInterface extends TemplateDataInterface
{
    // Primary typed methods
    public function getRouteName(): string;
    public function getRouteParams(): array;
    public function getLabel(): string;
    public function getUrl(): ?string;
    public function getImg(): ?string;
    public function getAlt(): ?string;
    public function getTracking(): ?string;
    public function getDataAttr(): array;
    public function getElementId(): ?string;
    public function getSeoLink(): ?string;
    public function isNoLabel(): bool;
}
