<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\LinkBarConfigInterface;
use Webedia\UiBundle\Contracts\Module\LinkBarItemInterface;

class LinkBarConfig implements LinkBarConfigInterface
{
    /** @param LinkBarItemInterface[] $linkBar */
    public function __construct(
        private array $linkBar = [],
        private ?string $iconLeft = null,
        private ?string $iconRight = null,
        private array $linkBarClasses = []
    ) {}

    /** @return LinkBarItemInterface[] */
    public function getLinkBar(): array
    {
        return $this->linkBar;
    }

    public function getIconLeft(): ?string
    {
        return $this->iconLeft;
    }

    public function getIconRight(): ?string
    {
        return $this->iconRight;
    }

    public function getLinkBarClasses(): array
    {
        return $this->linkBarClasses;
    }

    public function validate(): bool
    {
        return true; // Link bar has no required fields
    }
}