<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

interface HeaderMainConfigInterface extends TemplateDataInterface
{
    public function getLogoSrc(): ?string;
    public function getLogoPath(): ?string;
    public function getLogoAlt(): ?string;
    public function getLogoWidth(): ?int;
    public function getLogoHeight(): ?int;
    public function getMenuXhrPath(): ?string;
    public function getMenuObj(): mixed; // Knp\Menu\ItemInterface or array
    public function isMenuHasSubnavHtml(): bool;
    public function getSearchPath(): ?string;
    public function getSearchLinks(): array;
    public function getSearchPlaceholder(): ?string;
    public function getSearchCancelLabel(): ?string;
    public function getNewsletterHref(): ?string;
    public function isDarkModeEnabled(): bool;
}