<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\HeaderMainConfigInterface;

class HeaderMainConfig implements HeaderMainConfigInterface
{
    public function __construct(
        private ?string $logoSrc = null,
        private ?string $logoPath = null,
        private ?string $logoAlt = null,
        private ?int $logoWidth = null,
        private ?int $logoHeight = null,
        private ?string $menuXhrPath = null,
        private mixed $menuObj = null,
        private bool $menuHasSubnavHtml = false,
        private ?string $searchPath = null,
        private array $searchLinks = [],
        private ?string $searchPlaceholder = null,
        private ?string $searchCancelLabel = null,
        private ?string $newsletterHref = null,
        private bool $darkModeEnabled = false
    ) {}

    public function getLogoSrc(): ?string
    {
        return $this->logoSrc;
    }

    public function getLogoPath(): ?string
    {
        return $this->logoPath;
    }

    public function getLogoAlt(): ?string
    {
        return $this->logoAlt;
    }

    public function getLogoWidth(): ?int
    {
        return $this->logoWidth;
    }

    public function getLogoHeight(): ?int
    {
        return $this->logoHeight;
    }

    public function getMenuXhrPath(): ?string
    {
        return $this->menuXhrPath;
    }

    public function getMenuObj(): mixed
    {
        return $this->menuObj;
    }

    public function isMenuHasSubnavHtml(): bool
    {
        return $this->menuHasSubnavHtml;
    }

    public function getSearchPath(): ?string
    {
        return $this->searchPath;
    }

    public function getSearchLinks(): array
    {
        return $this->searchLinks;
    }

    public function getSearchPlaceholder(): ?string
    {
        return $this->searchPlaceholder;
    }

    public function getSearchCancelLabel(): ?string
    {
        return $this->searchCancelLabel;
    }

    public function getNewsletterHref(): ?string
    {
        return $this->newsletterHref;
    }

    public function isDarkModeEnabled(): bool
    {
        return $this->darkModeEnabled;
    }

    public function validate(): bool
    {
        return true; // Header has no required fields
    }
}