<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\FooterMainConfigInterface;

class FooterMainConfig implements FooterMainConfigInterface
{
    public function __construct(
        private ?string $footerLogoBrandImgSrc = null,
        private ?string $footerLogoBrandImgAlt = null,
        private ?int $footerLogoBrandImgWidth = null,
        private ?int $footerLogoBrandImgHeight = null,
        private bool $lazyloadBrandLogo = true,
        private ?string $footerLogoGroupImgSrc = null,
        private ?string $footerLogoGroupImgAlt = null,
        private ?int $footerLogoGroupImgWidth = null,
        private ?int $footerLogoGroupImgHeight = null,
        private ?string $footerCopyright = null,
        private ?string $footerAllRightsReserved = null
    ) {}

    public function getFooterLogoBrandImgSrc(): ?string
    {
        return $this->footerLogoBrandImgSrc;
    }

    public function getFooterLogoBrandImgAlt(): ?string
    {
        return $this->footerLogoBrandImgAlt;
    }

    public function getFooterLogoBrandImgWidth(): ?int
    {
        return $this->footerLogoBrandImgWidth;
    }

    public function getFooterLogoBrandImgHeight(): ?int
    {
        return $this->footerLogoBrandImgHeight;
    }

    public function isLazyloadBrandLogo(): bool
    {
        return $this->lazyloadBrandLogo;
    }

    public function getFooterLogoGroupImgSrc(): ?string
    {
        return $this->footerLogoGroupImgSrc;
    }

    public function getFooterLogoGroupImgAlt(): ?string
    {
        return $this->footerLogoGroupImgAlt;
    }

    public function getFooterLogoGroupImgWidth(): ?int
    {
        return $this->footerLogoGroupImgWidth;
    }

    public function getFooterLogoGroupImgHeight(): ?int
    {
        return $this->footerLogoGroupImgHeight;
    }

    public function getFooterCopyright(): ?string
    {
        return $this->footerCopyright;
    }

    public function getFooterAllRightsReserved(): ?string
    {
        return $this->footerAllRightsReserved;
    }

    public function validate(): bool
    {
        return true; // Footer has no required fields
    }
}