<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\DropdownConfigInterface;

class DropdownConfig implements DropdownConfigInterface
{
    public function __construct(
        private array $dropdownClasses = [],
        private bool $alreadyFiltered = false,
        private ?string $defaultPath = null,
        private string $ctaText,
        private array $data = [],
        private ?string $currentStatus = null,
        private string $valueKey = 'label'
    ) {}

    public function getDropdownClasses(): array
    {
        return $this->dropdownClasses;
    }

    public function isAlreadyFiltered(): bool
    {
        return $this->alreadyFiltered;
    }

    public function getDefaultPath(): ?string
    {
        return $this->defaultPath;
    }

    public function getCtaText(): string
    {
        return $this->ctaText;
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function getCurrentStatus(): ?string
    {
        return $this->currentStatus;
    }

    public function getValueKey(): string
    {
        return $this->valueKey;
    }

    public function validate(): bool
    {
        return !empty($this->ctaText);
    }
}