<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\DirectoryConfigInterface;

class DirectoryConfig implements DirectoryConfigInterface
{
    public function __construct(
        private array $directoryAlphaClasses = [],
        private ?string $letterDirectory = null,
        private array $entitiesDirectory = [],
        private string $titleMarkup = 'span',
        private string $itemMarkup = 'span'
    ) {}

    public function getDirectoryAlphaClasses(): array
    {
        return $this->directoryAlphaClasses;
    }

    public function getLetterDirectory(): ?string
    {
        return $this->letterDirectory;
    }

    public function getEntitiesDirectory(): array
    {
        return $this->entitiesDirectory;
    }

    public function getTitleMarkup(): string
    {
        return $this->titleMarkup;
    }

    public function getItemMarkup(): string
    {
        return $this->itemMarkup;
    }

    public function validate(): bool
    {
        return true; // Directory has no required fields
    }
}