<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\BreadcrumbConfigInterface;

class BreadcrumbConfig implements BreadcrumbConfigInterface
{
    public function __construct(
        private string $ariaLevel = '1',
        private ?string $seoBreadcrumb = null,
        private ?string $seoH1Title = null
    ) {}

    public function getAriaLevel(): string
    {
        return $this->ariaLevel;
    }

    public function getSeoBreadcrumb(): ?string
    {
        return $this->seoBreadcrumb;
    }

    public function getSeoH1Title(): ?string
    {
        return $this->seoH1Title;
    }

    public function validate(): bool
    {
        return true; // Breadcrumb has no required fields
    }
}