<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\AuthorConfigInterface;

class AuthorConfig implements AuthorConfigInterface
{
    public function __construct(
        private ?string $type = null,
        private ?string $authorImg = null,
        private string $authorImgWidth = '35',
        private string $authorImgHeight = '35',
        private string $by = '',
        private string $authorName,
        private ?string $authorLink = null,
        private bool $authorEnabled = false,
        private ?string $authorBio = null
    ) {}

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getAuthorImg(): ?string
    {
        return $this->authorImg;
    }

    public function getAuthorImgWidth(): string
    {
        return $this->authorImgWidth;
    }

    public function getAuthorImgHeight(): string
    {
        return $this->authorImgHeight;
    }

    public function getBy(): string
    {
        return $this->by;
    }

    public function getAuthorName(): string
    {
        return $this->authorName;
    }

    public function getAuthorLink(): ?string
    {
        return $this->authorLink;
    }

    public function isAuthorEnabled(): bool
    {
        return $this->authorEnabled;
    }

    public function getAuthorBio(): ?string
    {
        return $this->authorBio;
    }

    public function validate(): bool
    {
        return !empty($this->authorName);
    }
}