<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Module;

use Webedia\UiBundle\Contracts\Module\ArticleHeadlineConfigInterface;

class ArticleHeadlineConfig implements ArticleHeadlineConfigInterface
{
    public function __construct(
        private array $classes = [],
        private string $articlePageHeadline
    ) {}

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function getArticlePageHeadline(): string
    {
        return $this->articlePageHeadline;
    }

    public function validate(): bool
    {
        return !empty($this->articlePageHeadline);
    }
}