<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\TitleLogoInterface;

/**
 * Implementation of TitleLogoInterface.
 */
class TitleLogo implements TitleLogoInterface
{
    public function __construct(
        private string $src,
        private ?int $width = null,
        private ?int $height = null,
        private ?string $alt = null
    ) {}

    public function getSrc(): string
    {
        return $this->src;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function getHeight(): ?int
    {
        return $this->height;
    }

    public function getAlt(): ?string
    {
        return $this->alt;
    }

    public function validate(): bool
    {
        return !empty($this->src);
    }
}