<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

/**
 * Interface for title component configuration.
 */
interface TitleConfigInterface extends TemplateDataInterface
{
    public function getTitleText(): string;
    public function getTitleLink(): ?string;
    public function getSubtitleText(): ?string;
    public function isTypePage(): bool;
    public function getTitleLogo(): ?TitleLogoInterface;
    public function getAriaLevel(): ?string;
    public function getTitleMarkup(): ?string;
    public function getTitleContainerClasses(): array;
    public function getTitleTextClasses(): array;
    public function getTitleSubtextClasses(): array;
    public function getTitleLinkClasses(): array;
    public function getTitleContainerId(): ?string;
    public function isTitleTextWithRoller(): bool;
    public function isTitleUppercase(): bool;
}