<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\TitleConfigInterface;
use Webedia\UiBundle\Contracts\Component\TitleLogoInterface;

/**
 * Implementation of TitleConfigInterface.
 */
class TitleConfig implements TitleConfigInterface
{
    public function __construct(
        private string $titleText,
        private ?string $titleLink = null,
        private ?string $subtitleText = null,
        private bool $typePage = false,
        private ?TitleLogoInterface $titleLogo = null,
        private ?string $ariaLevel = null,
        private ?string $titleMarkup = null,
        private array $titleContainerClasses = [],
        private array $titleTextClasses = [],
        private array $titleSubtextClasses = [],
        private array $titleLinkClasses = [],
        private ?string $titleContainerId = null,
        private bool $titleTextWithRoller = false,
        private bool $titleUppercase = false
    ) {}

    public function getTitleText(): string
    {
        return $this->titleText;
    }

    public function getTitleLink(): ?string
    {
        return $this->titleLink;
    }

    public function getSubtitleText(): ?string
    {
        return $this->subtitleText;
    }

    public function isTypePage(): bool
    {
        return $this->typePage;
    }

    public function getTitleLogo(): ?TitleLogoInterface
    {
        return $this->titleLogo;
    }

    public function getAriaLevel(): ?string
    {
        return $this->ariaLevel;
    }

    public function getTitleMarkup(): ?string
    {
        return $this->titleMarkup;
    }

    public function getTitleContainerClasses(): array
    {
        return $this->titleContainerClasses;
    }

    public function getTitleTextClasses(): array
    {
        return $this->titleTextClasses;
    }

    public function getTitleSubtextClasses(): array
    {
        return $this->titleSubtextClasses;
    }

    public function getTitleLinkClasses(): array
    {
        return $this->titleLinkClasses;
    }

    public function getTitleContainerId(): ?string
    {
        return $this->titleContainerId;
    }

    public function isTitleTextWithRoller(): bool
    {
        return $this->titleTextWithRoller;
    }

    public function isTitleUppercase(): bool
    {
        return $this->titleUppercase;
    }

    public function validate(): bool
    {
        return !empty($this->titleText);
    }
}