<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\ThumbnailPictureSourceInterface;

/**
 * Implementation of ThumbnailPictureSourceInterface.
 */
class ThumbnailPictureSource implements ThumbnailPictureSourceInterface
{
    public function __construct(
        private string $src,
        private ?int $width = null,
        private ?int $height = null
    ) {}

    public function getSrc(): string
    {
        return $this->src;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function getHeight(): ?int
    {
        return $this->height;
    }

    public function validate(): bool
    {
        return !empty($this->src);
    }
}