<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

/**
 * Interface for thumbnail picture configuration.
 */
interface ThumbnailPictureInterface extends TemplateDataInterface
{
    /** @return array<string, ThumbnailPictureSourceInterface> */
    public function getSources(): array;
    public function getLarge(): ?ThumbnailPictureSourceInterface;
    public function getMedium(): ?ThumbnailPictureSourceInterface;
    public function getSmall(): ?ThumbnailPictureSourceInterface;
}