<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\ThumbnailPictureInterface;
use Webedia\UiBundle\Contracts\Component\ThumbnailPictureSourceInterface;

/**
 * Implementation of ThumbnailPictureInterface.
 */
class ThumbnailPicture implements ThumbnailPictureInterface
{
    /** @param array<string, ThumbnailPictureSourceInterface> $sources */
    public function __construct(
        private array $sources = []
    ) {}

    /** @return array<string, ThumbnailPictureSourceInterface> */
    public function getSources(): array
    {
        return $this->sources;
    }

    public function getLarge(): ?ThumbnailPictureSourceInterface
    {
        return $this->sources['large'] ?? null;
    }

    public function getMedium(): ?ThumbnailPictureSourceInterface
    {
        return $this->sources['medium'] ?? null;
    }

    public function getSmall(): ?ThumbnailPictureSourceInterface
    {
        return $this->sources['small'] ?? null;
    }

    public function validate(): bool
    {
        return !empty($this->sources);
    }
}