<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

/**
 * Interface for thumbnail component configuration.
 */
interface ThumbnailConfigInterface extends TemplateDataInterface
{
    public function getFigureClasses(): array;
    public function getImgClasses(): array;
    public function getHref(): ?string;
    public function getPicture(): ?string;
    public function getWidth(): ?int;
    public function getHeight(): ?int;
    public function getAlt(): ?string;
    public function getRatio(): ?string;
    /** @return LabelConfigInterface[] */
    public function getLabels(): array;
    public function isPlay(): bool;
    public function getSponso(): ?string;
    public function isCover(): bool;
    public function getSrcObj(): ?ThumbnailPictureInterface;
    public function getVwObj(): array;
    public function getDataAttributesLink(): array;
    public function getDataAttributesImg(): array;
    public function getTarget(): ?string;
    public function getFigcaption(): ?string;
    public function getMarkupThumb(): ?string;
    public function isLazyload(): bool;
    public function isAmpImg(): bool;
    public function getAmpImgLayout(): ?string;
    public function isImg100(): bool;
}