<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\LabelConfigInterface;
use Webedia\UiBundle\Contracts\Component\ThumbnailConfigInterface;
use Webedia\UiBundle\Contracts\Component\ThumbnailPictureInterface;

/**
 * Implementation of ThumbnailConfigInterface.
 */
class ThumbnailConfig implements ThumbnailConfigInterface
{
    /** @param LabelConfigInterface[] $labels */
    public function __construct(
        private array $figureClasses = [],
        private array $imgClasses = [],
        private ?string $href = null,
        private ?string $picture = null,
        private ?int $width = null,
        private ?int $height = null,
        private ?string $alt = null,
        private ?string $ratio = null,
        private array $labels = [],
        private bool $play = false,
        private ?string $sponso = null,
        private bool $cover = true,
        private ?ThumbnailPictureInterface $srcObj = null,
        private array $vwObj = [],
        private array $dataAttributesLink = [],
        private array $dataAttributesImg = [],
        private ?string $target = null,
        private ?string $figcaption = null,
        private ?string $markupThumb = null,
        private bool $lazyload = false,
        private bool $ampImg = false,
        private ?string $ampImgLayout = null,
        private bool $img100 = false
    ) {}

    public function getFigureClasses(): array
    {
        return $this->figureClasses;
    }

    public function getImgClasses(): array
    {
        return $this->imgClasses;
    }

    public function getHref(): ?string
    {
        return $this->href;
    }

    public function getPicture(): ?string
    {
        return $this->picture;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function getHeight(): ?int
    {
        return $this->height;
    }

    public function getAlt(): ?string
    {
        return $this->alt;
    }

    public function getRatio(): ?string
    {
        return $this->ratio;
    }

    /** @return LabelConfigInterface[] */
    public function getLabels(): array
    {
        return $this->labels;
    }

    public function isPlay(): bool
    {
        return $this->play;
    }

    public function getSponso(): ?string
    {
        return $this->sponso;
    }

    public function isCover(): bool
    {
        return $this->cover;
    }

    public function getSrcObj(): ?ThumbnailPictureInterface
    {
        return $this->srcObj;
    }

    public function getVwObj(): array
    {
        return $this->vwObj;
    }

    public function getDataAttributesLink(): array
    {
        return $this->dataAttributesLink;
    }

    public function getDataAttributesImg(): array
    {
        return $this->dataAttributesImg;
    }

    public function getTarget(): ?string
    {
        return $this->target;
    }

    public function getFigcaption(): ?string
    {
        return $this->figcaption;
    }

    public function getMarkupThumb(): ?string
    {
        return $this->markupThumb;
    }

    public function isLazyload(): bool
    {
        return $this->lazyload;
    }

    public function isAmpImg(): bool
    {
        return $this->ampImg;
    }

    public function getAmpImgLayout(): ?string
    {
        return $this->ampImgLayout;
    }

    public function isImg100(): bool
    {
        return $this->img100;
    }

    public function validate(): bool
    {
        return !empty($this->picture) || $this->srcObj !== null;
    }
}