<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\SubtitleConfigInterface;

/**
 * Implementation of SubtitleConfigInterface.
 */
class SubtitleConfig implements SubtitleConfigInterface
{
    public function __construct(
        private string $subtitle,
        private string $markup = 'div',
        private array $classes = [],
        private ?string $href = null
    ) {}

    public function getMarkup(): string
    {
        return $this->markup;
    }

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function getHref(): ?string
    {
        return $this->href;
    }

    public function getSubtitle(): string
    {
        return $this->subtitle;
    }

    public function validate(): bool
    {
        return !empty($this->subtitle);
    }
}