<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\ShareConfigInterface;

/**
 * Implementation of ShareConfigInterface.
 */
class ShareConfig implements ShareConfigInterface
{
    public function __construct(
        private array $shareContainerClass = [],
        private array $iconContainerClass = [],
        private array $iconClass = [],
        private array $txtContainerClass = [],
        private ?string $dataTitle = null,
        private ?string $dataText = null,
        private ?string $dataHref = null,
        private array $dataTracking = [],
        private ?string $txtWording = null
    ) {}

    public function getShareContainerClass(): array
    {
        return $this->shareContainerClass;
    }

    public function getIconContainerClass(): array
    {
        return $this->iconContainerClass;
    }

    public function getIconClass(): array
    {
        return $this->iconClass;
    }

    public function getTxtContainerClass(): array
    {
        return $this->txtContainerClass;
    }

    public function getDataTitle(): ?string
    {
        return $this->dataTitle;
    }

    public function getDataText(): ?string
    {
        return $this->dataText;
    }

    public function getDataHref(): ?string
    {
        return $this->dataHref;
    }

    public function getDataTracking(): array
    {
        return $this->dataTracking;
    }

    public function getTxtWording(): ?string
    {
        return $this->txtWording;
    }

    public function validate(): bool
    {
        return true; // Share component has no required fields
    }
}