<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\LabelConfigInterface;

/**
 * Implementation of LabelConfigInterface.
 */
class LabelConfig implements LabelConfigInterface
{
    public function __construct(
        private string $value,
        private ?string $type = null,
        private ?string $color = null,
        private ?string $background = null,
        private ?string $size = null,
        private array $classes = [],
        private bool $hasContentHolder = false
    ) {}

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function getBackground(): ?string
    {
        return $this->background;
    }

    public function getSize(): ?string
    {
        return $this->size;
    }

    public function getClasses(): array
    {
        return $this->classes;
    }

    public function getValue(): string
    {
        return $this->value;
    }

    public function hasContentHolder(): bool
    {
        return $this->hasContentHolder;
    }

    public function validate(): bool
    {
        return !empty($this->value);
    }
}