<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\DataAttributesConfigInterface;

/**
 * Implementation of DataAttributesConfigInterface.
 */
class DataAttributesConfig implements DataAttributesConfigInterface
{
    /** @param array<string, mixed> $dataAttributes */
    public function __construct(
        private array $dataAttributes = []
    ) {}

    /** @return array<string, mixed> */
    public function getDataAttributes(): array
    {
        return $this->dataAttributes;
    }

    public function validate(): bool
    {
        return true; // Data attributes are optional
    }
}