<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\Component\CtaSubcategoryConfigInterface;

/**
 * Implementation of CtaSubcategoryConfigInterface.
 */
class CtaSubcategoryConfig implements CtaSubcategoryConfigInterface
{
    public function __construct(
        private string $btnHref,
        private string $btnTitle,
        private bool $ctaSubcategoryArticle = false
    ) {}

    public function isCtaSubcategoryArticle(): bool
    {
        return $this->ctaSubcategoryArticle;
    }

    public function getBtnHref(): string
    {
        return $this->btnHref;
    }

    public function getBtnTitle(): string
    {
        return $this->btnTitle;
    }

    public function validate(): bool
    {
        return !empty($this->btnHref) && !empty($this->btnTitle);
    }
}