<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Contracts\Component;

use Webedia\UiBundle\Contracts\TemplateDataInterface;

/**
 * Interface for button component configuration.
 */
interface ButtonConfigInterface extends TemplateDataInterface
{
    public function getText(): string;
    public function getHref(): ?string;
    public function getType(): ?string;
    public function getSize(): ?string;
    public function getIcon(): ?string;
    public function getClasses(): array;
    public function getMarkup(): ?string;
    public function getBackground(): ?string;
    public function getColor(): ?string;
    public function getData(): array;
}